<?php
use WP_Statistics\Service\Admin\LicenseManagement\Plugin\PluginHandler;
$pluginHandler = new PluginHandler();
?>
<div class="wps-optionsMenu wps-settings-side">
    <div class="wps-settings-side__title"><?php esc_html_e('Settings', 'wp-statistics'); ?></div>
    <a data-tab="general-settings" class="wps-optionsMenuItem current">
        <svg width="17" height="18" viewBox="0 0 17 18" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path fill-rule="evenodd" clip-rule="evenodd" d="M7.78827 1.95469C7.40224 2.04209 7.03398 2.26343 6.79944 2.54903C6.68166 2.69245 6.54126 2.95036 6.43975 3.2097C6.36514 3.40039 6.31641 3.45407 6.21794 3.45407C6.18081 3.45407 6.00735 3.40583 5.83248 3.34687C5.6576 3.2879 5.4189 3.2162 5.30202 3.18751C4.82587 3.07068 4.32435 3.15638 3.9189 3.42385C3.77629 3.51793 3.29079 3.98171 3.09009 4.21559C2.93035 4.40172 2.77784 4.68729 2.71679 4.9145C2.6836 5.03805 2.67201 5.14668 2.67087 5.34532C2.66912 5.64673 2.68751 5.7342 2.8363 6.13195C3.00394 6.58012 3.00198 6.5835 2.34589 6.98157C1.85695 7.27822 1.56 7.67747 1.45756 8.17599C1.41195 8.39786 1.40936 9.4521 1.45384 9.68376C1.54001 10.1325 1.80363 10.5395 2.16765 10.7858C2.29551 10.8723 2.68449 11.0599 2.87682 11.1279C2.92208 11.1439 2.96592 11.1754 2.97421 11.1978C2.98394 11.2241 2.93741 11.3968 2.84346 11.683C2.6674 12.2195 2.63504 12.3653 2.63551 12.6195C2.63629 13.0263 2.76258 13.3851 3.01828 13.7072C3.16929 13.8974 3.77497 14.4824 3.9189 14.577C4.29838 14.8266 4.78603 14.9218 5.22323 14.8315C5.3133 14.8129 5.56023 14.7412 5.77192 14.6721C5.98361 14.6031 6.18574 14.5466 6.22113 14.5466C6.31633 14.5466 6.36573 14.6018 6.43975 14.7909C6.53837 15.0429 6.68064 15.307 6.78895 15.4391C6.99052 15.6849 7.27944 15.8809 7.61081 15.9966L7.80952 16.0659H8.50015H9.19077L9.3922 15.9957C9.96589 15.7955 10.3038 15.4471 10.5605 14.7909C10.6346 14.6018 10.684 14.5466 10.7792 14.5466C10.8145 14.5466 11.0209 14.6045 11.2377 14.6752C11.7239 14.8339 11.8706 14.8654 12.1193 14.865C12.464 14.8643 12.7765 14.7717 13.0613 14.5858C13.2295 14.4759 13.7972 13.9363 13.9644 13.7273C14.2174 13.4111 14.3417 13.0904 14.3597 12.7073C14.3738 12.4059 14.3425 12.2488 14.1521 11.6686C14.0623 11.3951 14.0126 11.2122 14.023 11.1937C14.0323 11.1771 14.152 11.1172 14.289 11.0605C14.742 10.8733 14.9743 10.7202 15.1668 10.4819C15.3761 10.2227 15.4882 9.98707 15.5465 9.68376C15.5909 9.4521 15.5883 8.39786 15.5427 8.17599C15.4337 7.64527 15.1491 7.28062 14.5692 6.92845C14.2075 6.70876 14.1418 6.65961 14.0988 6.57636C14.0499 6.48188 14.0608 6.40791 14.164 6.13195C14.3126 5.73456 14.3311 5.64669 14.3296 5.34532C14.3285 5.12209 14.3193 5.04986 14.2721 4.89276C14.2117 4.69152 14.1222 4.49927 14.0179 4.34657C13.9332 4.22254 13.3718 3.64915 13.207 3.51842C12.8817 3.26025 12.5264 3.13645 12.1088 3.13568C11.8748 3.13528 11.6245 3.19231 11.136 3.35741C10.9787 3.41057 10.8196 3.45407 10.7824 3.45407C10.6839 3.45407 10.6352 3.40044 10.5605 3.2097C10.3037 2.55335 9.96482 2.20406 9.3922 2.0054L9.19077 1.9355L8.55327 1.93066C8.07791 1.92705 7.88334 1.93317 7.78827 1.95469ZM8.16015 3.34472C7.93279 3.36863 7.90089 3.39899 7.7667 3.71929C7.60626 4.10224 7.54963 4.19304 7.34234 4.3997C7.12336 4.61798 6.98521 4.70667 6.72069 4.79881C6.56871 4.85175 6.49055 4.86545 6.29508 4.87342C5.99617 4.88562 5.90121 4.8672 5.37688 4.6952C5.14602 4.61946 4.92432 4.55914 4.87702 4.55916C4.82785 4.5592 4.76078 4.57828 4.71792 4.6044C4.60742 4.67176 4.14375 5.14921 4.1097 5.2307C4.0641 5.33988 4.07228 5.38897 4.18546 5.68496C4.34513 6.1025 4.38561 6.38003 4.33427 6.70532C4.27197 7.1003 4.06459 7.48277 3.77366 7.73928C3.71101 7.79449 3.55593 7.90397 3.42902 7.98253C2.93643 8.28751 2.91412 8.30362 2.87565 8.38201C2.84303 8.44852 2.8383 8.52188 2.83921 8.9472C2.84055 9.58325 2.83541 9.57265 3.21952 9.73132C3.64386 9.90661 3.7612 9.97644 3.9542 10.1684C4.10235 10.3158 4.15463 10.3862 4.23402 10.5449C4.36825 10.8134 4.40735 11.0018 4.39367 11.3142C4.3833 11.5514 4.37658 11.58 4.22088 12.0518C4.13023 12.3265 4.05894 12.5791 4.05898 12.6255C4.05902 12.6712 4.07834 12.7401 4.10203 12.7789C4.15779 12.8704 4.63005 13.3427 4.72153 13.3984C4.83229 13.466 4.93095 13.4519 5.37661 13.3053C5.89757 13.1339 5.99507 13.115 6.29508 13.1272C6.49055 13.1352 6.56871 13.1489 6.72069 13.2018C6.98521 13.294 7.12336 13.3827 7.34234 13.6009C7.54963 13.8076 7.60626 13.8984 7.7667 14.2813C7.92684 14.6636 7.9224 14.6613 8.50015 14.6613C9.07789 14.6613 9.07345 14.6636 9.23359 14.2813C9.39318 13.9004 9.45104 13.8077 9.65804 13.6009C9.87625 13.383 10.0145 13.2942 10.2796 13.2017C10.4342 13.1478 10.5078 13.1352 10.7136 13.1272C11.0149 13.1157 11.1325 13.139 11.6595 13.3153C12.0652 13.451 12.169 13.4653 12.2759 13.4002C12.3663 13.345 12.8432 12.8692 12.8979 12.7795C12.9219 12.7402 12.9413 12.6715 12.9413 12.6255C12.9414 12.5789 12.8702 12.3278 12.7787 12.0518C12.6171 11.5644 12.6158 11.5591 12.6063 11.294C12.5948 10.9773 12.6346 10.7957 12.7742 10.5273C12.9455 10.1981 13.2298 9.95725 13.6457 9.78906C14.145 9.58714 14.1412 9.59192 14.162 9.14342C14.1758 8.84815 14.1688 8.62005 14.1405 8.43426C14.1258 8.33745 14.0543 8.27697 13.6974 8.05916C13.5217 7.95193 13.3224 7.81793 13.2545 7.76138C12.8493 7.42419 12.6128 6.86493 12.6504 6.33255C12.6659 6.1133 12.7042 5.96453 12.8249 5.65604C12.9277 5.39303 12.936 5.33935 12.8906 5.2307C12.8565 5.14921 12.3929 4.67176 12.2824 4.6044C12.1683 4.53489 12.0717 4.54743 11.6595 4.68534C11.1325 4.86161 11.0149 4.88498 10.7136 4.8734C10.5078 4.86548 10.4342 4.85285 10.2796 4.79892C10.015 4.70659 9.87685 4.61791 9.65795 4.3997C9.45066 4.19304 9.39403 4.10224 9.23359 3.71929C9.13133 3.47522 9.09804 3.42515 9.00662 3.37787C8.94047 3.34366 8.37921 3.32168 8.16015 3.34472ZM8.11765 6.18699C7.76683 6.25038 7.49695 6.33502 7.2464 6.46027C6.48452 6.84109 5.94645 7.51875 5.73571 8.36282C5.69092 8.5423 5.68531 8.61304 5.68522 9.00032C5.68514 9.46893 5.70713 9.61092 5.83467 9.96448C6.17442 10.9063 7.02829 11.6212 8.01949 11.7937C8.26193 11.8359 8.7361 11.8363 8.97568 11.7945C10.0147 11.6134 10.8769 10.8647 11.1962 9.86645C11.2912 9.56935 11.3264 9.33514 11.3264 9.00032C11.3264 8.66551 11.2912 8.43129 11.1962 8.13419C10.9364 7.32195 10.3056 6.65706 9.4989 6.34511C9.19874 6.22905 8.97785 6.19099 8.5639 6.18402C8.34768 6.18038 8.14686 6.18172 8.11765 6.18699ZM8.34077 7.59916C7.6314 7.66924 7.09337 8.27361 7.09337 9.00032C7.09337 9.65474 7.52335 10.2083 8.15794 10.3708C8.33508 10.4161 8.66481 10.4162 8.84236 10.3709C9.34369 10.243 9.74282 9.84386 9.87075 9.34253C9.91603 9.16499 9.91597 8.83525 9.8706 8.65811C9.69374 7.96742 9.05913 7.52816 8.34077 7.59916Z"/>
        </svg>
        <span><?php esc_html_e('General', 'wp-statistics'); ?></span>
    </a>

    <a data-tab="privacy-settings" class="wps-optionsMenuItem">
        <svg width="17" height="18" viewBox="0 0 17 18" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path fill-rule="evenodd" clip-rule="evenodd" d="M8.26626 1.97993C8.13737 2.00562 7.91329 2.08701 6.03501 2.79034C3.23137 3.84018 3.23825 3.83735 2.92811 4.07095C2.57185 4.3393 2.28774 4.78797 2.18189 5.24937C2.13969 5.43337 2.13771 5.5123 2.13008 7.32129C2.12456 8.63171 2.12953 9.27601 2.14647 9.44629C2.23219 10.308 2.56031 11.1646 3.1191 11.9857C4.03808 13.3358 5.58837 14.631 7.55438 15.6911C8.0252 15.945 8.18113 15.9962 8.48938 15.9984C8.8433 16.0009 8.99955 15.9442 9.66876 15.5706C10.3216 15.2061 10.9461 14.8027 11.4963 14.3899C13.3487 13.0001 14.4644 11.4826 14.7792 9.92441C14.8735 9.45783 14.8784 9.31507 14.87 7.32129C14.8623 5.51242 14.8603 5.43335 14.8181 5.24937C14.7636 5.0119 14.6728 4.79558 14.5435 4.59559C14.3078 4.23113 14.0732 4.02794 13.6546 3.82577C13.4259 3.71531 9.27984 2.14198 8.88979 2.01763C8.78733 1.98497 8.36811 1.95961 8.26626 1.97993ZM6.27938 4.21628C5.07557 4.66907 4.0309 5.06654 3.95788 5.09954C3.80584 5.16826 3.67443 5.29797 3.6053 5.44755L3.55938 5.54691V7.49129V9.43566L3.61971 9.68898C3.85121 10.6613 4.38103 11.4829 5.40813 12.4623C6.10111 13.1232 7.16211 13.8682 8.21934 14.4364L8.50181 14.5882L8.78246 14.437C9.83523 13.8697 10.8867 13.1315 11.5866 12.4682C12.6053 11.5028 13.149 10.6603 13.3803 9.68898L13.4406 9.43566V7.49129V5.54691L13.3832 5.43004C13.2997 5.25997 13.1909 5.16496 12.9713 5.07044C12.7152 4.96018 8.52714 3.38965 8.49423 3.39152C8.47988 3.39233 7.48319 3.76348 6.27938 4.21628ZM10.4231 6.90334C10.3764 6.91877 10.3142 6.94365 10.285 6.95868C10.2558 6.9737 9.68459 7.53211 9.01568 8.19959L7.79948 9.41318L7.29443 8.91257C6.69815 8.32152 6.67969 8.30941 6.37501 8.30941C6.13888 8.30941 6.02068 8.3545 5.87508 8.50011C5.72947 8.64571 5.68438 8.76391 5.68438 9.00004C5.68438 9.31768 5.66793 9.29531 6.56249 10.1943C7.46715 11.1035 7.48141 11.1143 7.77751 11.1144C8.11213 11.1145 7.98236 11.2227 9.68321 9.52515C10.7836 8.42695 11.2118 7.98609 11.2547 7.90749C11.3028 7.81928 11.3152 7.76575 11.3224 7.6163C11.3303 7.4517 11.3253 7.42008 11.2728 7.3032C11.2044 7.15076 11.0543 6.99965 10.9059 6.93384C10.7825 6.87914 10.5426 6.86399 10.4231 6.90334Z"/>
        </svg>
        <span><?php esc_html_e('Privacy & Data Protection', 'wp-statistics'); ?></span>
    </a>

    <a data-tab="display-settings" class="wps-optionsMenuItem">
        <svg width="17" height="18" viewBox="0 0 17 18" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path fill-rule="evenodd" clip-rule="evenodd" d="M3.37888 2.63814C2.86756 2.72057 2.50491 2.97017 2.2868 3.38979C2.1319 3.68778 2.13575 3.63502 2.13575 5.46167C2.13575 6.95714 2.13896 7.1098 2.17315 7.23604C2.30063 7.70677 2.66434 8.08736 3.11805 8.22474C3.33805 8.29136 3.64949 8.30209 5.12138 8.29378C6.53582 8.28577 6.5817 8.28424 6.74275 8.23951C7.23875 8.10177 7.6021 7.73841 7.73984 7.24242C7.78457 7.08136 7.7861 7.03549 7.79412 5.62104C7.80242 4.14916 7.79169 3.83772 7.72507 3.61772C7.58924 3.16915 7.2158 2.80871 6.747 2.67371C6.63183 2.64056 6.46544 2.63665 5.02575 2.63329C4.14919 2.63125 3.40809 2.63344 3.37888 2.63814ZM10.3941 2.64942C9.87883 2.72312 9.4299 3.11346 9.27373 3.62354C9.20873 3.83587 9.19787 4.15668 9.20614 5.62104C9.21408 7.02692 9.21591 7.08221 9.25956 7.2391C9.40032 7.74519 9.75468 8.0996 10.2606 8.24032C10.4177 8.28403 10.4724 8.28584 11.8789 8.29378C13.5861 8.30341 13.7432 8.29378 14.0558 8.16031C14.3051 8.05389 14.5961 7.77307 14.7164 7.52292C14.8703 7.20311 14.8645 7.28326 14.8645 5.46167C14.8645 3.93235 14.8619 3.81571 14.8249 3.67667C14.6845 3.14977 14.2475 2.74653 13.7195 2.65686C13.5625 2.63017 13.2793 2.62524 12.0302 2.62741C11.2048 2.62885 10.4686 2.63875 10.3941 2.64942ZM3.55404 5.45621L3.5595 6.86417H4.962H6.3645V5.46167V4.05917L4.95654 4.05371L3.54858 4.04825L3.55404 5.45621ZM10.6349 4.07511C10.6293 4.08973 10.6272 4.72323 10.6302 5.48292L10.6358 6.86417H12.0383H13.4408L13.4462 5.45636L13.4517 4.04854H12.0484C10.9453 4.04854 10.6429 4.05422 10.6349 4.07511ZM3.3895 9.72314C3.1943 9.7466 3.07619 9.77952 2.92763 9.85177C2.55089 10.0351 2.28265 10.3592 2.17315 10.7635C2.13896 10.8898 2.13575 11.0424 2.13575 12.5379C2.13575 14.0672 2.13834 14.1839 2.17538 14.3229C2.30507 14.8098 2.69014 15.1948 3.177 15.3245C3.31604 15.3616 3.43268 15.3642 4.962 15.3642C6.455 15.3642 6.61034 15.3609 6.73638 15.3269C7.20413 15.2007 7.58833 14.8335 7.72507 14.3819C7.79169 14.1619 7.80242 13.8504 7.79412 12.3785C7.7861 10.9641 7.78457 10.9182 7.73984 10.7572C7.60212 10.2612 7.23896 9.89801 6.74275 9.75999C6.58053 9.71488 6.54464 9.71381 5.05763 9.70956C4.22197 9.70721 3.47131 9.7133 3.3895 9.72314ZM10.485 9.72272C9.88478 9.78602 9.42138 10.1775 9.26041 10.7572C9.21568 10.9182 9.21415 10.9641 9.20614 12.3785C9.19787 13.8429 9.20873 14.1637 9.27373 14.376C9.4353 14.9037 9.88288 15.2804 10.435 15.3533C10.5574 15.3695 11.1043 15.3748 12.1551 15.37C13.6348 15.3632 13.7017 15.3612 13.8454 15.3193C14.2305 15.2071 14.5456 14.9466 14.7165 14.5992C14.8697 14.2878 14.8645 14.3601 14.8645 12.5379C14.8645 11.0424 14.8613 10.8898 14.8271 10.7635C14.7685 10.5471 14.6556 10.339 14.5116 10.1818C14.251 9.89735 13.9938 9.76951 13.5895 9.72327C13.3706 9.69824 10.7215 9.69777 10.485 9.72272ZM3.5632 11.1388C3.55531 11.1467 3.54888 11.7827 3.54888 12.5522V13.9513L4.95669 13.9459L6.3645 13.9404V12.5379V11.1354L4.97101 11.13C4.20459 11.1269 3.57106 11.1309 3.5632 11.1388ZM10.6349 11.1512C10.6293 11.1659 10.6272 11.7995 10.6302 12.5592L10.6358 13.9404L12.0437 13.9459L13.4517 13.9513L13.4462 12.5434L13.4408 11.1354L12.0429 11.13C10.936 11.1256 10.643 11.13 10.6349 11.1512Z"/>
        </svg>
        <span><?php esc_html_e('Display Options', 'wp-statistics'); ?></span>
    </a>

    <a data-tab="notifications-settings" class="wps-optionsMenuItem">
        <svg width="17" height="18" viewBox="0 0 17 18" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path fill-rule="evenodd" clip-rule="evenodd" d="M3.55934 3.34016C3.12868 3.36787 2.84285 3.43247 2.58881 3.55944C2.0736 3.81696 1.67523 4.28697 1.52197 4.81812C1.41313 5.19535 1.41309 5.1973 1.41309 9.00005C1.41309 12.7375 1.41364 12.7606 1.51054 13.1409C1.67697 13.794 2.26351 14.3905 2.91121 14.5653C3.28211 14.6654 3.1524 14.6632 8.52121 14.6632C14.106 14.6632 13.7845 14.6705 14.1895 14.5347C14.7993 14.3303 15.3318 13.7593 15.4894 13.1409C15.5863 12.7606 15.5868 12.7375 15.5868 9.00005C15.5868 5.26256 15.5863 5.23948 15.4894 4.85917C15.3277 4.22467 14.7569 3.63001 14.1312 3.44415C13.7655 3.33552 14.0147 3.34041 8.64871 3.33674C5.90799 3.33487 3.61777 3.3364 3.55934 3.34016ZM3.52466 4.77294C3.27777 4.79338 3.19921 4.82373 3.0627 4.95142C2.90641 5.09762 2.86597 5.21028 2.86163 5.51167L2.85809 5.75783L4.39871 6.61378C6.52171 7.79326 7.00186 8.03184 7.51449 8.16189C8.11803 8.31499 8.88437 8.31536 9.47961 8.16284C10.0519 8.01622 10.4143 7.83377 13.0793 6.35043L14.1418 5.75907L14.1383 5.51229C14.134 5.21022 14.0936 5.09772 13.9372 4.95142C13.797 4.82024 13.7286 4.79572 13.4355 4.77143C13.1336 4.74642 3.82794 4.74784 3.52466 4.77294ZM2.85214 10.0553L2.85809 12.7294L2.90819 12.8402C2.96444 12.9646 3.12794 13.13 3.24173 13.1775C3.28277 13.1947 3.43317 13.2178 3.57597 13.2289C3.92203 13.2558 13.0779 13.2558 13.4239 13.2289C13.7231 13.2056 13.7938 13.1815 13.9298 13.0561C14.0542 12.9414 14.1032 12.8456 14.1312 12.6621C14.1459 12.5658 14.1514 11.6546 14.1476 9.95337L14.1418 7.38983L13.3768 7.81481C12.1302 8.50735 11.5213 8.83845 11.1748 9.01216C10.4061 9.39749 9.96636 9.54486 9.23309 9.66288C9.12373 9.6805 8.85841 9.69002 8.48934 9.68957C7.99368 9.68898 7.87797 9.68241 7.63934 9.64129C6.94965 9.52253 6.52229 9.36885 5.68434 8.93834C5.33562 8.75918 3.66614 7.84433 2.95839 7.44457L2.84621 7.38121L2.85214 10.0553Z"/>
        </svg>
        <span><?php esc_html_e('Email Reports', 'wp-statistics'); ?></span>
    </a>

    <a data-tab="exclusions-settings" class="wps-optionsMenuItem">
        <svg width="17" height="18" viewBox="0 0 17 18" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path fill-rule="evenodd" clip-rule="evenodd" d="M2.64582 1.93745C2.62245 1.94212 2.55073 1.95623 2.48645 1.96879C2.03688 2.0567 1.60738 2.47033 1.47356 2.94427C1.43786 3.07073 1.43457 3.18204 1.43457 4.26177C1.43457 5.4209 1.43538 5.4437 1.4817 5.5899C1.58621 5.91972 1.50827 5.83493 4.03117 8.36302L6.37452 10.7111L6.38017 13.1336L6.38582 15.5561L6.43174 15.6555C6.49417 15.7906 6.63808 15.9417 6.76747 16.0079C6.92268 16.0874 7.16699 16.0984 7.34207 16.0339C7.46447 15.9887 7.53005 15.9265 8.98436 14.4752C10.2393 13.223 10.5091 12.9436 10.5569 12.8468L10.6146 12.7299L10.6205 11.7205L10.6265 10.7111L12.9695 8.36302C15.492 5.83502 15.4142 5.9197 15.5187 5.5899C15.565 5.44376 15.5658 5.42056 15.5658 4.2724C15.5658 2.97377 15.5677 2.99457 15.4229 2.69046C15.2656 2.35994 14.9419 2.09153 14.5564 1.97187C14.4475 1.93806 14.0385 1.93537 8.56395 1.93226C5.33235 1.93044 2.6692 1.93277 2.64582 1.93745ZM2.9195 3.34182C2.85851 3.34962 2.85207 3.35818 2.83981 3.44775C2.83246 3.50136 2.82645 3.90949 2.82645 4.35474V5.16426L5.17115 7.5127C6.58916 8.93299 7.54205 9.90335 7.58217 9.96795C7.68012 10.1256 7.75177 10.3338 7.7768 10.5334C7.79025 10.6407 7.79895 11.2895 7.79895 12.1873V13.6647L8.5002 12.9636L9.20145 12.2626V11.4725C9.20145 11.023 9.21133 10.6113 9.22437 10.5174C9.25096 10.3264 9.32374 10.1201 9.41822 9.96795C9.45834 9.90335 10.4117 8.93252 11.8305 7.51141L14.1765 5.16169L14.1699 4.26723C14.1663 3.77528 14.1554 3.36481 14.1456 3.35508C14.1284 3.33791 3.05233 3.32484 2.9195 3.34182Z"/>
        </svg>
        <span><?php esc_html_e('Filtering & Exceptions', 'wp-statistics'); ?></span>
    </a>

    <a data-tab="access-settings" class="wps-optionsMenuItem">
        <svg width="17" height="18" viewBox="0 0 17 18" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path fill-rule="evenodd" clip-rule="evenodd" d="M7.36283 1.93645C6.56117 2.05165 5.88349 2.37884 5.3258 2.91995C4.79755 3.43247 4.45819 4.05899 4.30893 4.79719C4.26753 5.00185 4.26075 5.09924 4.26198 5.47199C4.26317 5.83842 4.27093 5.94306 4.31088 6.13074C4.41685 6.62871 4.63027 7.12589 4.90369 7.51173C5.07826 7.75806 5.47547 8.15922 5.70994 8.32599C6.77724 9.08512 8.14619 9.2112 9.3072 8.65725C9.68031 8.47924 9.95186 8.28959 10.26 7.99179C10.7797 7.48959 11.1139 6.87068 11.2767 6.10949C11.337 5.82754 11.331 5.05243 11.2663 4.75482C10.9597 3.34556 9.90813 2.2891 8.51033 1.98599C8.33958 1.94897 8.21221 1.93868 7.8622 1.93361C7.62261 1.93012 7.39789 1.9314 7.36283 1.93645ZM7.58302 3.34835C7.32966 3.37045 7.10313 3.43592 6.85283 3.5594C6.24414 3.85971 5.81914 4.4278 5.70261 5.09692C5.65777 5.35432 5.67207 5.73421 5.73593 5.98199C5.79392 6.207 5.95459 6.54647 6.08381 6.71696C6.1988 6.86868 6.45237 7.11442 6.59568 7.21302C6.74891 7.31844 7.06546 7.46079 7.2672 7.515C7.50348 7.5785 8.04244 7.58483 8.27367 7.52682C8.89965 7.36978 9.41109 6.96148 9.6897 6.39636C10.2723 5.21469 9.6455 3.78786 8.38312 3.42204C8.28304 3.39303 8.13686 3.36392 8.05826 3.35731C7.97965 3.35072 7.88186 3.34242 7.84095 3.33883C7.80005 3.33526 7.68398 3.33953 7.58302 3.34835ZM7.32468 9.72228C5.96815 9.84453 4.74517 10.4137 3.79072 11.3671C3.13535 12.0217 2.66551 12.7924 2.38404 13.6745C2.15184 14.4022 2.05511 15.3698 2.18543 15.6614C2.25035 15.8066 2.40129 15.9543 2.5555 16.0235C2.66945 16.0746 2.70217 16.0797 2.86597 16.0719C3.07934 16.0616 3.22229 15.998 3.35015 15.8565C3.49446 15.6967 3.53043 15.5802 3.55047 15.2073C3.61186 14.0644 4.03282 13.1191 4.82607 12.3426C5.18086 11.9952 5.48473 11.7812 5.93908 11.5584C6.61258 11.2282 7.36108 11.084 8.10167 11.1419C8.54407 11.1764 8.62818 11.174 8.76624 11.1223C8.92961 11.0612 9.09576 10.8939 9.15813 10.7277C9.19524 10.6289 9.20314 10.5696 9.19725 10.4339C9.18822 10.2252 9.13059 10.0948 8.98439 9.95204C8.86085 9.83138 8.72601 9.77738 8.46774 9.74511C8.20424 9.71217 7.57607 9.69963 7.32468 9.72228ZM11.6235 10.454C10.8909 10.6088 10.3017 11.1152 10.0482 11.808C9.96098 12.0465 9.92345 12.2557 9.92345 12.5036V12.7103L9.77713 12.8259C9.51297 13.0346 9.3428 13.2835 9.26086 13.581C9.21876 13.7338 9.21462 13.7993 9.21462 14.312C9.21462 14.9481 9.23691 15.0865 9.38028 15.3405C9.56513 15.6678 9.81899 15.8817 10.1702 16.0058L10.3378 16.0651L11.9772 16.0712C13.8009 16.0779 13.797 16.0781 14.0778 15.9387C14.4524 15.7528 14.7155 15.4333 14.8276 15.0282C14.8813 14.8342 14.8813 13.7897 14.8276 13.5958C14.7421 13.2871 14.5604 13.0165 14.3166 12.8351L14.1739 12.7289L14.1735 12.5801C14.1725 12.1462 14.0389 11.7083 13.7942 11.3371C13.69 11.179 13.407 10.8967 13.241 10.7852C13.0587 10.6627 12.7871 10.5378 12.5857 10.4837C12.3726 10.4264 11.8328 10.4097 11.6235 10.454ZM11.9167 11.8479C11.6325 11.8949 11.3655 12.1765 11.3435 12.4526L11.3367 12.5376L12.0457 12.5432L12.7546 12.5488L12.7403 12.4476C12.6857 12.0599 12.3061 11.7835 11.9167 11.8479ZM10.715 13.9663L10.6247 13.9744V14.3102V14.6459L10.7553 14.6596C10.8272 14.6671 11.4043 14.6732 12.0378 14.6732C12.6714 14.6732 13.2485 14.6671 13.3203 14.6596L13.451 14.6459V14.312V13.978L13.3203 13.9644C13.1849 13.9502 10.8745 13.9519 10.715 13.9663Z"/>
        </svg>
        <span><?php esc_html_e('Roles & Permissions', 'wp-statistics'); ?></span>
    </a>

    <a data-tab="advanced-settings" class="wps-optionsMenuItem">
        <svg width="17" height="18" viewBox="0 0 17 18" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path fill-rule="evenodd" clip-rule="evenodd" d="M6.36453 1.93854C6.22938 1.95722 5.96458 2.03092 5.80682 2.09375C5.15853 2.35198 4.61727 2.91672 4.38724 3.5749L4.34848 3.6858L3.14651 3.69177L1.94453 3.69774L1.83828 3.74656C1.69208 3.81371 1.54496 3.96456 1.47614 4.11792C1.42501 4.23186 1.41991 4.26459 1.42777 4.42838C1.43506 4.57992 1.44717 4.63094 1.49798 4.7242C1.57425 4.86418 1.69095 4.97138 1.84635 5.04425L1.96578 5.10024L3.15854 5.10639L4.3513 5.11253L4.39909 5.24451C4.51321 5.55961 4.69166 5.84629 4.92988 6.0971C6.07602 7.30393 8.03089 7.07339 8.87798 5.63149C8.9609 5.49037 9.09515 5.18297 9.09515 5.13424C9.09515 5.11835 9.97947 5.10989 12.0648 5.10592L15.0345 5.10024L15.154 5.04425C15.3094 4.97138 15.4261 4.86418 15.5023 4.7242C15.5531 4.63094 15.5652 4.57992 15.5725 4.42838C15.5804 4.26459 15.5753 4.23186 15.5242 4.11792C15.4553 3.96456 15.3082 3.81371 15.162 3.74656L15.0558 3.69774L12.0792 3.69213L9.10274 3.68655L9.06447 3.56463C8.96935 3.26157 8.7468 2.91105 8.48026 2.64451C8.11957 2.28383 7.67948 2.05076 7.18036 1.95607C7.01973 1.9256 6.53372 1.91517 6.36453 1.93854ZM6.56878 3.3499C6.17914 3.39735 5.80916 3.72928 5.70648 4.12349C5.61128 4.48897 5.71604 4.8741 5.98335 5.14143C6.45928 5.61734 7.24853 5.53642 7.61175 4.97444C7.83649 4.62673 7.83964 4.16614 7.61962 3.82765C7.38861 3.4723 7.00307 3.29701 6.56878 3.3499ZM11.3795 6.53621C10.4468 6.66441 9.66718 7.29031 9.35015 8.16539L9.30209 8.29801L5.61268 8.30351L1.92328 8.30899L1.81758 8.36101C1.68277 8.42734 1.55287 8.55724 1.48655 8.69205C1.44243 8.7817 1.43453 8.82839 1.43453 8.99962C1.43453 9.17085 1.44243 9.21754 1.48655 9.30719C1.55287 9.442 1.68277 9.5719 1.81758 9.63822L1.92328 9.69024L5.61187 9.69573L9.30049 9.70123L9.36739 9.87635C9.84356 11.1229 11.2189 11.7733 12.482 11.3493C13.1852 11.1132 13.7698 10.5391 14.0253 9.83368L14.0733 9.70087H14.5478C15.1063 9.70087 15.1868 9.68228 15.3598 9.51332C15.5197 9.35719 15.5658 9.24225 15.5658 8.99962C15.5658 8.75699 15.5197 8.64204 15.3598 8.48592C15.1868 8.31696 15.1063 8.29837 14.5478 8.29837H14.0733L14.0253 8.16556C13.728 7.34469 13.0086 6.72797 12.157 6.56394C11.9484 6.52376 11.5687 6.51022 11.3795 6.53621ZM11.4763 7.9589C11.3348 7.98874 11.0947 8.11118 10.9832 8.21039C10.8623 8.31788 10.7537 8.47938 10.6882 8.64899C10.6175 8.83187 10.6175 9.16737 10.6882 9.35024C10.7957 9.62849 10.9742 9.82512 11.2308 9.94796C11.8066 10.2236 12.4521 9.9587 12.6871 9.35024C12.7578 9.16737 12.7578 8.83187 12.6871 8.64899C12.5247 8.22861 12.1742 7.96846 11.7417 7.94732C11.6477 7.94273 11.5283 7.94794 11.4763 7.9589ZM4.9089 11.156C4.29852 11.2596 3.75934 11.5772 3.37178 12.0616C3.2306 12.2381 3.04249 12.5738 2.97736 12.7656L2.9393 12.8777L2.45255 12.8884C1.98206 12.8986 1.96178 12.9009 1.84635 12.955C1.69095 13.0279 1.57425 13.1351 1.49798 13.275C1.44717 13.3683 1.43506 13.4193 1.42777 13.5709C1.41991 13.7347 1.42501 13.7674 1.47614 13.8813C1.54496 14.0347 1.69208 14.1855 1.83828 14.2527C1.93771 14.2984 1.97608 14.3019 2.43693 14.3082L2.92934 14.3149L3.00588 14.5124C3.15718 14.9029 3.4792 15.3276 3.8212 15.5875C4.01917 15.738 4.42963 15.9366 4.68578 16.0058C4.88166 16.0587 4.93066 16.0632 5.31265 16.0641C5.70223 16.0649 5.73974 16.0614 5.93953 16.0059C6.2141 15.9295 6.57463 15.7548 6.78953 15.5939C7.16886 15.3099 7.47582 14.9054 7.62725 14.49L7.68823 14.3227L11.372 14.3121L15.0558 14.3015L15.162 14.2527C15.3082 14.1855 15.4553 14.0347 15.5242 13.8813C15.5753 13.7674 15.5804 13.7347 15.5725 13.5709C15.5652 13.4193 15.5531 13.3683 15.5023 13.275C15.4261 13.1351 15.3094 13.0279 15.154 12.955L15.0345 12.899L11.3603 12.8884L7.68609 12.8777L7.6499 12.7715C7.44909 12.1819 6.9298 11.6143 6.34902 11.3497C5.90848 11.1489 5.37419 11.0771 4.9089 11.156ZM5.03878 12.582C4.85448 12.6315 4.68427 12.7351 4.54844 12.8803C3.91032 13.5624 4.38071 14.6546 5.31265 14.6546C5.7252 14.6546 6.07332 14.4423 6.2545 14.0801C6.60899 13.3716 6.09338 12.5424 5.30288 12.5498C5.2206 12.5505 5.10177 12.565 5.03878 12.582Z"/>
        </svg>
        <span><?php esc_html_e('Advanced Options', 'wp-statistics'); ?></span>
    </a>

   <div class="wps-settings-side__title wps-settings-side__title--premium"><?php esc_html_e('Premium Add-Ons', 'wp-statistics'); ?></div>

    <?php
    $addons = [
        ['tab' => 'data-plus-settings', 'title' => 'Data Plus', 'key' => 'data-plus','icon'=>'<svg width="17" height="18" viewBox="0 0 17 18" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M13.0079 1.91602H14.1413C14.5309 1.91602 14.8496 2.23477 14.8496 2.62435V13.2493C14.8496 13.6389 14.5309 13.9577 14.1413 13.9577H13.0079C12.6184 13.9577 12.2996 13.6389 12.2996 13.2493V2.62435C12.2996 2.23477 12.6184 1.91602 13.0079 1.91602ZM9.04128 4.17561H7.90795C7.51836 4.17561 7.19961 4.49436 7.19961 4.88394V13.2494C7.19961 13.6389 7.51836 13.9577 7.90795 13.9577H9.04128C9.43086 13.9577 9.74961 13.6389 9.74961 13.2494V4.88394C9.74961 4.49436 9.43086 4.17561 9.04128 4.17561ZM2.80794 6.4352H3.94128C4.33086 6.4352 4.64961 6.74687 4.64961 7.14353V13.2494C4.64961 13.639 4.33086 13.9577 3.94128 13.9577H2.80794C2.41836 13.9577 2.09961 13.639 2.09961 13.2494V7.14353C2.09961 6.75395 2.41836 6.4352 2.80794 6.4352ZM2.09961 16.6139H14.8496C15.14 16.6139 15.3809 16.3731 15.3809 16.0827C15.3809 15.7923 15.14 15.5514 14.8496 15.5514H2.09961C1.80919 15.5514 1.56836 15.7923 1.56836 16.0827C1.56836 16.3731 1.80919 16.6139 2.09961 16.6139Z" fill="#56585A"/></svg>'],
        ['tab' => 'realtime-stats-settings', 'title' => 'Real-time Stats', 'key' => 'realtime-stats','icon'=>'<svg width="17" height="18" viewBox="0 0 17 18" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M4.75595 4.07125C4.23609 4.37163 3.75707 5.1052 3.75707 6.4785V11.5218C3.75707 12.8951 4.23609 13.6287 4.75595 13.9291C5.27568 14.2294 6.15021 14.2781 7.34016 13.5915L11.7177 11.0698C11.7178 11.0697 11.718 11.0696 11.7181 11.0695C11.7182 11.0695 11.7182 11.0695 11.7182 11.0695C12.9075 10.3831 13.3031 9.60105 13.3031 9.00017C13.3031 8.3992 12.9074 7.61704 11.7177 6.93057C11.7177 6.93055 11.7177 6.93054 11.7177 6.93052L7.34016 4.40886C6.15021 3.72223 5.27568 3.77096 4.75595 4.07125ZM8.23728 2.85282C6.71449 1.97431 5.12426 1.78405 3.85736 2.51606C2.59045 3.24808 1.96094 4.72097 1.96094 6.4785V11.5218C1.96094 13.2794 2.59045 14.7523 3.85736 15.4843C5.12441 16.2164 6.71488 16.026 8.23785 15.1472L12.6153 12.6255C14.1386 11.7466 15.0993 10.464 15.0993 9.00017C15.0993 7.53636 14.1386 6.25375 12.6153 5.37481L8.23785 2.85314C8.23774 2.85308 8.23764 2.85302 8.23753 2.85296C8.23745 2.85291 8.23736 2.85286 8.23728 2.85282Z" fill="black"/></svg>'],
        ['tab' => 'customization-settings', 'title' => 'Customization', 'key' => 'customization','icon'=>'<svg width="17" height="18" viewBox="0 0 17 18" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M11.4211 3.29829L13.9145 5.79163C15.3878 7.25788 15.6286 8.42663 14.722 9.69454H14.7149V9.70163C14.5165 9.97788 14.2615 10.2683 13.9145 10.6225L9.90529 14.6245C8.98446 15.5454 8.29737 16.0837 7.49696 16.0837C6.69654 16.0837 5.97404 15.5241 5.08154 14.6245L2.58112 12.1383C1.62487 11.182 0.859874 10.3037 1.15029 9.26954V9.24829V9.24121V9.23413C1.15029 9.23413 1.15738 9.23413 1.15738 9.22704C1.32029 8.64621 1.76654 8.12204 2.58112 7.30746L6.59029 3.29829C8.00696 1.88871 9.18279 1.06704 11.4211 3.29829ZM13.1778 8.55413H13.1849C13.7657 8.66746 14.2474 8.05121 13.9499 7.53413C13.9428 7.53413 13.9428 7.52704 13.9428 7.52704C13.787 7.25079 13.532 6.93204 13.1495 6.55663L10.6632 4.06329C9.07654 2.48371 8.63737 2.78829 7.34821 4.06329L3.34612 8.06538C3.18321 8.22829 3.03446 8.37704 2.90696 8.51871C2.92468 8.51517 2.94417 8.51162 2.96366 8.50808C2.98313 8.50454 3.00259 8.501 3.02029 8.49746C3.11238 8.48329 3.19737 8.46913 3.28946 8.44788C3.69321 8.36996 4.09696 8.30621 4.50779 8.24246L4.50835 8.24239C4.61441 8.22824 4.72049 8.2141 4.83362 8.19996C5.23737 8.15038 5.64821 8.10788 6.05904 8.07954C6.14404 8.07246 6.22904 8.06538 6.32112 8.05829C6.86654 8.02288 7.41904 7.99454 7.97154 7.99454C8.42487 7.99454 8.88529 8.00871 9.33862 8.03704H9.39529C9.91237 8.06538 10.4295 8.11496 10.9395 8.17871H10.9678C11.4778 8.24246 11.9807 8.32038 12.4765 8.41246C12.4882 8.41246 12.4978 8.41461 12.5064 8.41654C12.5134 8.41811 12.5198 8.41954 12.5261 8.41954C12.7457 8.46204 12.9653 8.50454 13.1778 8.55413ZM14.1907 11.8337C14.7149 11.8337 14.9486 12.117 15.2178 12.4499C15.7845 13.1512 16.0324 13.9091 15.9403 14.6458C15.834 15.4958 15.1115 16.0837 14.1907 16.0837C13.2699 16.0837 12.5474 15.4958 12.4411 14.6528C12.349 13.9162 12.604 13.1512 13.1707 12.4499C13.4328 12.117 13.6665 11.8337 14.1907 11.8337Z" fill="#292D32"/></svg>'],
        ['tab' => 'advanced-reporting-settings', 'title' => 'Advanced Reporting', 'key' => 'advanced-reporting','icon'=>'<svg width="17" height="18" viewBox="0 0 17 18" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M5.3125 1.91602H12.3958C14.5208 1.91602 15.9375 2.97852 15.9375 5.45768V10.4231C15.9375 12.9023 14.5208 13.9648 12.3958 13.9648H9.86708C9.44917 13.9648 9.10917 13.5964 9.16583 13.1785C9.23667 12.6756 9.2225 12.1514 9.11625 11.6131C8.74083 9.77143 7.225 8.30518 5.36917 8.0006C4.44125 7.85185 3.55583 7.97935 2.77667 8.31935C2.30208 8.52477 1.77083 8.19893 1.77083 7.68185V5.45768C1.77083 2.97852 3.1875 1.91602 5.3125 1.91602ZM10.5117 7.64643L12.7288 5.8756C12.9554 5.69143 12.9908 5.35143 12.8067 5.12477C12.6296 4.89102 12.2896 4.8556 12.0629 5.03977L9.84583 6.8106C9.3075 7.24268 8.39375 7.24268 7.85542 6.8106L5.63833 5.03977C5.41167 4.8556 5.07875 4.8981 4.89458 5.12477C4.7175 5.35143 4.75292 5.69143 4.97958 5.8756L7.19667 7.64643C7.65708 8.02185 8.25917 8.20601 8.85417 8.20601C9.44917 8.20601 10.0442 8.02185 10.5117 7.64643ZM1.0625 12.541C1.0625 10.5789 2.64917 8.99935 4.60417 8.99935C6.56625 8.99935 8.14583 10.586 8.14583 12.541C8.14583 14.496 6.55917 16.0827 4.60417 16.0827C2.64917 16.0827 1.0625 14.5031 1.0625 12.541ZM4.60417 11.096H3.15917C2.89 11.096 2.6775 11.3156 2.6775 11.5777C2.6775 11.8398 2.89 12.0593 3.15917 12.0593H4.60417C4.87333 12.0593 5.08583 11.8398 5.08583 11.5777C5.08583 11.3156 4.87333 11.096 4.60417 11.096ZM2.6775 13.5043C2.6775 13.7664 2.89 13.986 3.15917 13.986H6.04917C6.31833 13.986 6.53792 13.7664 6.53792 13.5043C6.53792 13.2423 6.32542 13.0227 6.05625 13.0227H3.15917C2.89708 13.0227 2.6775 13.2423 2.6775 13.5043Z" fill="#292D32"/></svg>'],
        ['tab' => 'mini-chart-settings', 'title' => 'Mini Chart', 'key' => 'mini-chart','icon'=>'<svg width="17" height="18" viewBox="0 0 17 18" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M15.5795 6.03143V9.35352H12.6895C12.6045 9.34643 12.4203 9.24018 12.3778 9.16227L11.6412 7.76685C11.3508 7.21435 10.8478 6.90268 10.3095 6.93102C9.77118 6.95935 9.31077 7.3206 9.07701 7.90852L8.09952 10.3594L7.95785 9.99102C7.61077 9.09143 6.6191 8.41143 5.6416 8.41143L1.41285 8.43268V6.03143C1.41285 3.4531 2.94993 1.91602 5.52826 1.91602H11.4641C14.0424 1.91602 15.5795 3.4531 15.5795 6.03143ZM15.5795 11.9672V10.416H12.6895C12.2149 10.416 11.6553 10.076 11.4358 9.65805L10.6991 8.26264C10.5008 7.88722 10.2174 7.90847 10.0616 8.29806L8.43243 12.4135C8.25535 12.8739 7.95785 12.8739 7.77368 12.4135L6.96618 10.3735C6.77493 9.87764 6.17993 9.47389 5.64868 9.47389L1.41285 9.49514L1.41285 9.49522H1.3916V11.1244C1.3916 11.3723 1.39869 11.6131 1.41285 11.8398L1.41285 11.8398L1.41285 11.9672C1.41285 14.5031 2.90035 16.0331 5.40077 16.0756C5.47868 16.0826 5.56368 16.0826 5.6416 16.0826H11.3083C11.4145 16.0826 11.5208 16.0826 11.6199 16.0756C14.1062 16.0189 15.5795 14.496 15.5795 11.9672Z" fill="#292D32"/></svg>'],
        ['tab' => 'rest-api-settings', 'title' => 'REST API', 'key' => 'rest-api','icon'=>'<svg width="17" height="18" viewBox="0 0 17 18" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M8.52474 1.91602C4.61474 1.91602 1.44141 5.08935 1.44141 8.99935C1.44141 12.9093 4.61474 16.0827 8.52474 16.0827C12.4347 16.0827 15.6081 12.9093 15.6081 8.99935C15.6081 5.08935 12.4347 1.91602 8.52474 1.91602ZM6.06682 10.0406C6.27224 10.246 6.27224 10.586 6.06682 10.7914C5.96057 10.8977 5.82599 10.9473 5.69141 10.9473C5.55682 10.9473 5.42224 10.8977 5.31599 10.7914L3.89932 9.37477C3.69391 9.16935 3.69391 8.82935 3.89932 8.62393L5.31599 7.20727C5.52141 7.00185 5.86141 7.00185 6.06682 7.20727C6.27224 7.41268 6.27224 7.75268 6.06682 7.9581L5.02557 8.99935L6.06682 10.0406ZM9.72182 7.55435L8.30516 10.8623C8.22016 11.0606 8.02182 11.181 7.81641 11.181C7.74557 11.181 7.67474 11.1668 7.61099 11.1385C7.34182 11.0252 7.21432 10.7135 7.33474 10.4373L8.75141 7.12935C8.86474 6.86018 9.17641 6.73268 9.44557 6.8531C9.71474 6.97352 9.83516 7.28518 9.72182 7.55435ZM13.1502 9.37477L11.7335 10.7914C11.6272 10.8977 11.4927 10.9473 11.3581 10.9473C11.2235 10.9473 11.0889 10.8977 10.9827 10.7914C10.7772 10.586 10.7772 10.246 10.9827 10.0406L12.0239 8.99935L10.9827 7.9581C10.7772 7.75268 10.7772 7.41268 10.9827 7.20727C11.1881 7.00185 11.5281 7.00185 11.7335 7.20727L13.1502 8.62393C13.3556 8.82935 13.3556 9.16935 13.1502 9.37477Z" fill="#292D32"/></svg>'],
        ['tab' => 'widgets-settings', 'title' => 'Advanced Widgets', 'key' => 'widgets','icon'=>'<svg width="17" height="18" viewBox="0 0 17 18" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M7.42513 6.54802V3.33219C7.42513 2.33344 6.9718 1.92969 5.84555 1.92969H2.98388C1.85763 1.92969 1.4043 2.33344 1.4043 3.33219V6.54094C1.4043 7.54677 1.85763 7.94344 2.98388 7.94344H5.84555C6.9718 7.95052 7.42513 7.54677 7.42513 6.54802ZM15.571 3.33219V6.54802C15.571 7.54677 15.1176 7.95052 13.9914 7.94344H11.1297C10.0035 7.94344 9.55013 7.54677 9.55013 6.54094V3.33219C9.55013 2.33344 10.0035 1.92969 11.1297 1.92969H13.9914C15.1176 1.92969 15.571 2.33344 15.571 3.33219ZM12.9147 12.3776H14.5085C14.7989 12.3776 15.0397 12.6184 15.0397 12.9089C15.0397 13.1993 14.7989 13.4401 14.5085 13.4401H12.9147V15.0339C12.9147 15.3243 12.6739 15.5651 12.3835 15.5651C12.093 15.5651 11.8522 15.3243 11.8522 15.0339V13.4401H10.2585C9.96805 13.4401 9.72721 13.1993 9.72721 12.9089C9.72721 12.6184 9.96805 12.3776 10.2585 12.3776H11.8522V10.7839C11.8522 10.4934 12.093 10.2526 12.3835 10.2526C12.6739 10.2526 12.9147 10.4934 12.9147 10.7839V12.3776ZM7.42513 11.6551V14.5168C7.42513 15.643 6.9718 16.0964 5.84555 16.0964H2.98388C1.85763 16.0964 1.4043 15.643 1.4043 14.5168V11.6551C1.4043 10.5289 1.85763 10.0755 2.98388 10.0755H5.84555C6.9718 10.0755 7.42513 10.5289 7.42513 11.6551Z" fill="#292D32"/></svg>'],
    ];

    foreach ($addons as $addon) :
        $isActive = \WP_STATISTICS\Helper::isAddOnActive($addon['key']);
        ?>
         <a data-tab="<?php echo esc_attr($addon['tab']); ?>"
           class="wps-optionsMenuItem wps-optionsMenuItem--extension premium <?php echo $pluginHandler->isPluginActive('wp-statistics-'.$addon['key']) ? 'wps-license-activated' : '' ?> <?php echo $isActive ? 'active' : ''; ?>">
             <span class="wps-optionsMenuItem__title--extension">
                 <?php echo $addon['icon'] ?>
                <span><?php esc_html_e($addon['title'], 'wp-statistics'); ?></span>
             </span>
        </a>
    <?php endforeach; ?>
</div>